import * as i0 from '@angular/core';
import { Pipe, EventEmitter, Component, Inject, Input, Output, NgModule } from '@angular/core';
import * as i3 from '@angular/forms';
import { FormGroup, FormControl, FormsModule, ReactiveFormsModule } from '@angular/forms';
import * as i2 from '@angular/common';
import { DOCUMENT, CommonModule } from '@angular/common';

class KeyboardUtil {
    static ifTab(event) {
        return this.ifKey(event, 'Tab');
    }
    static ifDelete(event) {
        return this.ifKey(event, 'Delete;Del');
    }
    static ifBackspace(event) {
        return this.ifKey(event, 'Backspace');
    }
    static ifRightArrow(event) {
        return this.ifKey(event, 'ArrowRight;Right');
    }
    static ifLeftArrow(event) {
        return this.ifKey(event, 'ArrowLeft;Left');
    }
    static ifSpacebar(event) {
        return this.ifKey(event, 'Spacebar; '); //don't remove the space after ; as this will check for space key
    }
    static ifKey(event, keys) {
        let keysToCheck = keys.split(';');
        return keysToCheck.some(k => k === event.key);
    }
}

class KeysPipe {
    transform(value) {
        return Object.keys(value);
    }
}
/** @nocollapse */ KeysPipe.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: KeysPipe, deps: [], target: i0.ɵɵFactoryTarget.Pipe });
/** @nocollapse */ KeysPipe.ɵpipe = i0.ɵɵngDeclarePipe({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: KeysPipe, name: "keys" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: KeysPipe, decorators: [{
            type: Pipe,
            args: [{
                    name: 'keys'
                }]
        }] });

class NgOtpInputComponent {
    constructor(keysPipe, document) {
        this.keysPipe = keysPipe;
        this.document = document;
        this.config = { length: 4 };
        // tslint:disable-next-line: no-output-on-prefix
        this.onInputChange = new EventEmitter();
        this.inputControls = new Array(this.config.length);
        this.componentKey = Math.random()
            .toString(36)
            .substring(2) + new Date().getTime().toString(36);
    }
    get inputType() {
        var _a, _b;
        return ((_a = this.config) === null || _a === void 0 ? void 0 : _a.isPasswordInput)
            ? 'password'
            : ((_b = this.config) === null || _b === void 0 ? void 0 : _b.allowNumbersOnly)
                ? 'tel'
                : 'text';
    }
    ngOnInit() {
        this.otpForm = new FormGroup({});
        for (let index = 0; index < this.config.length; index++) {
            this.otpForm.addControl(this.getControlName(index), new FormControl());
        }
        this.otpForm.valueChanges.subscribe((v) => {
            this.keysPipe.transform(this.otpForm.controls).forEach((k) => {
                var val = this.otpForm.controls[k].value;
                if (val && val.length > 1) {
                    if (val.length >= this.config.length) {
                        this.setValue(val);
                    }
                    else {
                        this.rebuildValue();
                    }
                }
            });
        });
    }
    ngAfterViewInit() {
        if (!this.config.disableAutoFocus) {
            const containerItem = this.document.getElementById(`c_${this.componentKey}`);
            if (containerItem) {
                const ele = containerItem.getElementsByClassName('otp-input')[0];
                if (ele && ele.focus) {
                    ele.focus();
                }
            }
        }
    }
    getControlName(idx) {
        return `ctrl_${idx}`;
    }
    onKeyDown($event, inputIdx) {
        const prevInputId = this.getBoxId(inputIdx - 1);
        const currentInputId = this.getBoxId(inputIdx);
        if (KeyboardUtil.ifSpacebar($event)) {
            $event.preventDefault();
            return false;
        }
        if (KeyboardUtil.ifBackspace($event)) {
            if (!$event.target.value) {
                this.clearInput(prevInputId, inputIdx - 1);
                this.setSelected(prevInputId);
            }
            else {
                this.clearInput(currentInputId, inputIdx);
            }
            this.rebuildValue();
            return;
        }
    }
    onInput($event) {
        let newVal = this.currentVal ? `${this.currentVal}${$event.target.value}` : $event.target.value;
        if (this.config.allowNumbersOnly && !this.validateNumber(newVal)) {
            $event.target.value = '';
            $event.stopPropagation();
            $event.preventDefault();
            return;
        }
    }
    onKeyUp($event, inputIdx) {
        if (KeyboardUtil.ifTab($event)) {
            inputIdx -= 1;
        }
        const nextInputId = this.getBoxId(inputIdx + 1);
        const prevInputId = this.getBoxId(inputIdx - 1);
        const currentInputId = this.getBoxId(inputIdx);
        if (KeyboardUtil.ifRightArrow($event)) {
            $event.preventDefault();
            this.setSelected(nextInputId);
            return;
        }
        if (KeyboardUtil.ifLeftArrow($event)) {
            $event.preventDefault();
            this.setSelected(prevInputId);
            return;
        }
        if (KeyboardUtil.ifDelete($event)) {
            if (!$event.target.value) {
                this.clearInput(prevInputId, inputIdx - 1);
                this.setSelected(prevInputId);
            }
            else {
                this.clearInput(currentInputId, inputIdx);
            }
            this.rebuildValue();
            return;
        }
        if (!$event.target.value) {
            return;
        }
        if (this.ifValidKeyCode($event)) {
            this.setSelected(nextInputId);
        }
        this.rebuildValue();
    }
    validateNumber(val) {
        return val && /^[0-9]+$/.test(val);
    }
    getBoxId(idx) {
        return `otp_${idx}_${this.componentKey}`;
    }
    clearInput(eleId, inputIdx) {
        var _a;
        let ctrlName = this.getControlName(inputIdx);
        (_a = this.otpForm.controls[ctrlName]) === null || _a === void 0 ? void 0 : _a.setValue(null);
        const ele = this.document.getElementById(eleId);
        if (ele && ele instanceof HTMLInputElement) {
            ele.value = null;
        }
    }
    setSelected(eleId) {
        this.focusTo(eleId);
        const ele = this.document.getElementById(eleId);
        if (ele && ele.setSelectionRange) {
            setTimeout(() => {
                ele.setSelectionRange(0, 1);
            }, 0);
        }
    }
    ifValidKeyCode(event) {
        const inp = event.key;
        const isMobile = /iPhone|iPad|iPod|Android/i.test(navigator.userAgent);
        return (isMobile ||
            /[a-zA-Z0-9-_]/.test(inp));
    }
    focusTo(eleId) {
        const ele = this.document.getElementById(eleId);
        if (ele) {
            ele.focus();
        }
    }
    // method to set component value
    setValue(value) {
        if (this.config.allowNumbersOnly && isNaN(value)) {
            return;
        }
        this.otpForm.reset();
        if (!value) {
            this.rebuildValue();
            return;
        }
        value = value.toString().replace(/\s/g, ''); // remove whitespace
        Array.from(value).forEach((c, idx) => {
            if (this.otpForm.get(this.getControlName(idx))) {
                this.otpForm.get(this.getControlName(idx)).setValue(c);
            }
        });
        if (!this.config.disableAutoFocus) {
            const containerItem = this.document.getElementById(`c_${this.componentKey}`);
            var indexOfElementToFocus = value.length < this.config.length ? value.length : (this.config.length - 1);
            let ele = containerItem.getElementsByClassName('otp-input')[indexOfElementToFocus];
            if (ele && ele.focus) {
                ele.focus();
            }
        }
        this.rebuildValue();
    }
    rebuildValue() {
        var _a;
        let val = '';
        this.keysPipe.transform(this.otpForm.controls).forEach(k => {
            if (this.otpForm.controls[k].value) {
                let ctrlVal = this.otpForm.controls[k].value;
                let isLengthExceed = ctrlVal.length > 1;
                let isCaseTransformEnabled = !this.config.allowNumbersOnly && this.config.letterCase && (this.config.letterCase.toLocaleLowerCase() == 'upper' || this.config.letterCase.toLocaleLowerCase() == 'lower');
                ctrlVal = ctrlVal[0];
                let transformedVal = isCaseTransformEnabled ? this.config.letterCase.toLocaleLowerCase() == 'upper' ? ctrlVal.toUpperCase() : ctrlVal.toLowerCase() : ctrlVal;
                if (isCaseTransformEnabled && transformedVal == ctrlVal) {
                    isCaseTransformEnabled = false;
                }
                else {
                    ctrlVal = transformedVal;
                }
                val += ctrlVal;
                if (isLengthExceed || isCaseTransformEnabled) {
                    this.otpForm.controls[k].setValue(ctrlVal);
                }
            }
        });
        if ((_a = this.formCtrl) === null || _a === void 0 ? void 0 : _a.setValue) {
            this.formCtrl.setValue(val);
        }
        this.onInputChange.emit(val);
        this.currentVal = val;
    }
    handlePaste(e) {
        // Get pasted data via clipboard API
        let clipboardData = e.clipboardData || window['clipboardData'];
        if (clipboardData) {
            var pastedData = clipboardData.getData('Text');
        }
        // Stop data actually being pasted into div
        e.stopPropagation();
        e.preventDefault();
        if (!pastedData || (this.config.allowNumbersOnly && !this.validateNumber(pastedData))) {
            return;
        }
        this.setValue(pastedData);
    }
}
/** @nocollapse */ NgOtpInputComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgOtpInputComponent, deps: [{ token: KeysPipe }, { token: DOCUMENT }], target: i0.ɵɵFactoryTarget.Component });
/** @nocollapse */ NgOtpInputComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "13.3.12", type: NgOtpInputComponent, selector: "ng-otp-input", inputs: { config: "config", formCtrl: "formCtrl" }, outputs: { onInputChange: "onInputChange" }, ngImport: i0, template: "<div class=\"ng-otp-input-wrapper wrapper {{config.containerClass}}\" id=\"c_{{componentKey}}\" *ngIf=\"otpForm?.controls\"\r\n  [ngStyle]=\"config.containerStyles\">\r\n  <input (paste)=\"handlePaste($event)\" [pattern]=\"config.allowNumbersOnly ? '\\\\d*' : ''\" [type]=\"inputType\"  [placeholder]=\"config?.placeholder || ''\"\r\n    [ngStyle]=\"config.inputStyles\" \r\n    class=\"otp-input {{config.inputClass}}\" autocomplete=\"one-time-code\" *ngFor=\"let item of otpForm?.controls | keys;let i=index\"\r\n    [formControl]=\"otpForm.controls[item]\" #inp [id]=\"getBoxId(i)\" \r\n    (keyup)=\"onKeyUp($event,i)\" (input)=\"onInput($event)\" (keydown)=\"onKeyDown($event,i)\" >\r\n</div>", styles: [".otp-input{width:50px;height:50px;border-radius:4px;border:solid 1px #c5c5c5;text-align:center;font-size:32px}.ng-otp-input-wrapper .otp-input:not(:last-child){margin-right:8px}@media screen and (max-width: 767px){.otp-input{width:40px;font-size:24px;height:40px}}@media screen and (max-width: 420px){.otp-input{width:30px;font-size:18px;height:30px}}\n"], directives: [{ type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { type: i2.NgStyle, selector: "[ngStyle]", inputs: ["ngStyle"] }, { type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { type: i3.PatternValidator, selector: "[pattern][formControlName],[pattern][formControl],[pattern][ngModel]", inputs: ["pattern"] }, { type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { type: i3.FormControlDirective, selector: "[formControl]", inputs: ["formControl", "disabled", "ngModel"], outputs: ["ngModelChange"], exportAs: ["ngForm"] }], pipes: { "keys": KeysPipe } });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgOtpInputComponent, decorators: [{
            type: Component,
            args: [{ selector: 'ng-otp-input', template: "<div class=\"ng-otp-input-wrapper wrapper {{config.containerClass}}\" id=\"c_{{componentKey}}\" *ngIf=\"otpForm?.controls\"\r\n  [ngStyle]=\"config.containerStyles\">\r\n  <input (paste)=\"handlePaste($event)\" [pattern]=\"config.allowNumbersOnly ? '\\\\d*' : ''\" [type]=\"inputType\"  [placeholder]=\"config?.placeholder || ''\"\r\n    [ngStyle]=\"config.inputStyles\" \r\n    class=\"otp-input {{config.inputClass}}\" autocomplete=\"one-time-code\" *ngFor=\"let item of otpForm?.controls | keys;let i=index\"\r\n    [formControl]=\"otpForm.controls[item]\" #inp [id]=\"getBoxId(i)\" \r\n    (keyup)=\"onKeyUp($event,i)\" (input)=\"onInput($event)\" (keydown)=\"onKeyDown($event,i)\" >\r\n</div>", styles: [".otp-input{width:50px;height:50px;border-radius:4px;border:solid 1px #c5c5c5;text-align:center;font-size:32px}.ng-otp-input-wrapper .otp-input:not(:last-child){margin-right:8px}@media screen and (max-width: 767px){.otp-input{width:40px;font-size:24px;height:40px}}@media screen and (max-width: 420px){.otp-input{width:30px;font-size:18px;height:30px}}\n"] }]
        }], ctorParameters: function () {
        return [{ type: KeysPipe }, { type: Document, decorators: [{
                        type: Inject,
                        args: [DOCUMENT]
                    }] }];
    }, propDecorators: { config: [{
                type: Input
            }], onInputChange: [{
                type: Output
            }], formCtrl: [{
                type: Input
            }] } });

class NgOtpInputModule {
}
/** @nocollapse */ NgOtpInputModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgOtpInputModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
/** @nocollapse */ NgOtpInputModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgOtpInputModule, declarations: [NgOtpInputComponent, KeysPipe], imports: [CommonModule,
        FormsModule,
        ReactiveFormsModule], exports: [NgOtpInputComponent] });
/** @nocollapse */ NgOtpInputModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgOtpInputModule, providers: [KeysPipe], imports: [[
            CommonModule,
            FormsModule,
            ReactiveFormsModule
        ]] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.3.12", ngImport: i0, type: NgOtpInputModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [
                        CommonModule,
                        FormsModule,
                        ReactiveFormsModule
                    ],
                    declarations: [NgOtpInputComponent, KeysPipe],
                    exports: [NgOtpInputComponent],
                    providers: [KeysPipe]
                }]
        }] });

class Config {
}

/*
 * Public API Surface of ng-otp-input
 */

/**
 * Generated bundle index. Do not edit.
 */

export { NgOtpInputComponent, Config as NgOtpInputConfig, NgOtpInputModule };
//# sourceMappingURL=ng-otp-input.mjs.map
